//! TrackJS JavaScript error monitoring agent.
//! COPYRIGHT (c) 2017 ALL RIGHTS RESERVED
//! See License at https://trackjs.com/terms/
(function(h,x,m){"use awesome";if(h.trackJs)h.console&&h.console.warn&&h.console.warn("TrackJS global conflict");else{var n=function(a,c,b,d,e){this.util=a;this.onError=c;this.onFault=b;this.options=e;e.enabled&&this.initialize(d)};n.prototype={initialize:function(a){f.forEach(["EventTarget","Node","XMLHttpRequest"],function(c){f.has(a,c+".prototype.addEventListener")&&(c=a[c].prototype,c.hasOwnProperty("addEventListener")&&(this.wrapAndCatch(c,"addEventListener",1),this.wrapRemoveEventListener(c)))},
this);this.wrapAndCatch(a,"setTimeout",0);this.wrapAndCatch(a,"setInterval",0)},wrapAndCatch:function(a,c,b){var d=this,e=a[c];f.isWrappableFunction(e)&&(a[c]=function(){try{var g=Array.prototype.slice.call(arguments),k=g[b],l,h;if(d.options.bindStack)try{throw Error();}catch(m){h=m.stack,l=d.util.isoNow()}var E=function(){try{if(f.isObject(k))return k.handleEvent.apply(k,arguments);if(f.isFunction(k))return k.apply(this,arguments)}catch(c){throw d.onError("catch",c,{bindTime:l,bindStack:h}),f.wrapError(c);
}};if("addEventListener"===c&&(this._trackJsEvt||(this._trackJsEvt=new p),this._trackJsEvt.get(g[0],k,g[2])))return;try{k&&(f.isWrappableFunction(k)||f.isWrappableFunction(k.handleEvent))&&(g[b]=E,"addEventListener"===c&&this._trackJsEvt.add(g[0],k,g[2],g[b]))}catch(m){return e.apply(this,arguments)}return e.apply(this,g)}catch(m){a[c]=e,d.onFault(m)}})},wrapRemoveEventListener:function(a){if(a&&a.removeEventListener&&this.util.hasFunction(a.removeEventListener,"call")){var c=a.removeEventListener;
a.removeEventListener=function(a,d,e){if(this._trackJsEvt){var g=this._trackJsEvt.get(a,d,e);if(g)return this._trackJsEvt.remove(a,d,e),c.call(this,a,g,e)}return c.call(this,a,d,e)}}}};var p=function(){this.events=[]};p.prototype={add:function(a,c,b,d){-1>=this.indexOf(a,c,b)&&(b=this.getEventOptions(b),this.events.push([a,c,b.capture,b.once,b.passive,d]))},get:function(a,c,b){a=this.indexOf(a,c,b);return 0<=a?this.events[a][5]:m},getEventOptions:function(a){var c={capture:!1,once:!1,passive:!1};
return f.isBoolean(a)?f.extend(c,{capture:a}):f.extend(c,a)},indexOf:function(a,c,b){b=this.getEventOptions(b);for(var d=0;d<this.events.length;d++){var e=this.events[d];if(e[0]===a&&e[1]===c&&e[2]===b.capture&&e[3]===b.once&&e[4]===b.passive)return d}return-1},remove:function(a,c,b){a=this.indexOf(a,c,b);0<=a&&this.events.splice(a,1)}};var t=function(a,c){this.util=a;this.initCurrent(c)};t.prototype={current:{},initOnly:{cookie:!0,enabled:!0,token:!0,callback:{enabled:!0},console:{enabled:!0},navigation:{enabled:!0},
network:{enabled:!0},visitor:{enabled:!0},window:{enabled:!0,promise:!0}},defaults:{application:"",cookie:!1,enabled:!0,errorURL:"https://capture.trackjs.com/capture",errorNoSSLURL:"http://capture.trackjs.com/capture",faultURL:"https://usage.trackjs.com/fault.gif",onError:function(){return!0},serialize:function(a){function c(c){for(var a="<"+c.tagName.toLowerCase(),b=0;b<c.attributes.length;b++)a+=" "+c.attributes[b].name+'="'+c.attributes[b].value+'"';return a+">"}if(""===a)return"Empty String";
if(a===m)return"undefined";if(f.isString(a)||f.isNumber(a)||f.isBoolean(a)||f.isFunction(a))return""+a;if(h.HTMLElement&&a instanceof HTMLElement&&a.attributes)return c(a);var b;try{b=JSON.stringify(a,function(a,b){return b===m?"undefined":f.isNumber(b)&&isNaN(b)?"NaN":f.isError(b)?{name:b.name,message:b.message,stack:b.stack}:h.HTMLElement&&b instanceof HTMLElement&&b.attributes?c(b):b})}catch(e){b="";for(var d in a)a.hasOwnProperty(d)&&(b+=',"'+d+'":"'+a[d]+'"');b=b?"{"+b.replace(",","")+"}":"Unserializable Object"}return b.replace(/"undefined"/g,
"undefined").replace(/"NaN"/g,"NaN")},sessionId:"",token:"",userId:"",version:"",callback:{enabled:!0,bindStack:!1},console:{enabled:!0,display:!0,error:!0,warn:!1,watch:["log","debug","info","warn","error"]},navigation:{enabled:!0},network:{enabled:!0,error:!0},visitor:{enabled:!0},usageURL:"https://usage.trackjs.com/usage.gif",window:{enabled:!0,promise:!0}},initCurrent:function(a){if(this.validate(a,this.defaults,"config",{}))return this.current=this.util.extend(this.current,this.defaults,a),!0;
this.current=this.util.extend(this.current,this.defaults);return!1},setCurrent:function(a){return this.validate(a,this.defaults,"config",this.initOnly)?(this.current=this.util.extend(this.current,a),!0):!1},validate:function(a,c,b,d){var e=!0;b=b||"";d=d||{};for(var g in a)if(a.hasOwnProperty(g))if(c.hasOwnProperty(g)){var k=typeof c[g];k!==typeof a[g]?(console.warn(b+"."+g+": property must be type "+k+"."),e=!1):"[object Array]"!==Object.prototype.toString.call(a[g])||this.validateArray(a[g],c[g],
b+"."+g)?"[object Object]"===Object.prototype.toString.call(a[g])?e=this.validate(a[g],c[g],b+"."+g,d[g]):d.hasOwnProperty(g)&&(console.warn(b+"."+g+": property cannot be set after load."),e=!1):e=!1}else console.warn(b+"."+g+": property not supported."),e=!1;return e},validateArray:function(a,c,b){var d=!0;b=b||"";for(var e=0;e<a.length;e++)this.util.contains(c,a[e])||(console.warn(b+"["+e+"]: invalid value: "+a[e]+"."),d=!1);return d}};var u=function(a,c,b,d,e,g,k){this.util=a;this.log=c;this.onError=
b;this.onFault=d;this.serialize=e;k.enabled&&(g.console=this.wrapConsoleObject(g.console,k))};u.prototype={wrapConsoleObject:function(a,c){a=a||{};var b=a.log||function(){},d=this,e;for(e=0;e<c.watch.length;e++)(function(e){var k=a[e]||b;a[e]=function(){try{var a=Array.prototype.slice.call(arguments);d.log.add("c",{timestamp:d.util.isoNow(),severity:e,message:d.serialize(1===a.length?a[0]:a)});if(c[e])if(f.isError(a[0])&&1===a.length)d.onError("console",a[0]);else try{throw Error(d.serialize(1===
a.length?a[0]:a));}catch(b){d.onError("console",b)}c.display&&(d.util.hasFunction(k,"apply")?k.apply(this,a):k(a[0],a[1],a[2]))}catch(b){d.onFault(b)}}})(c.watch[e]);return a},report:function(){return this.log.all("c")}};var v=function(a,c,b,d,e){this.config=a;this.util=c;this.log=b;this.window=d;this.document=e;this.correlationId=this.token=null;this.initialize()};v.prototype={initialize:function(){this.token=this.getCustomerToken();this.correlationId=this.getCorrelationId()},getCustomerToken:function(){if(this.config.current.token)return this.config.current.token;
var a=this.document.getElementsByTagName("script");return a[a.length-1].getAttribute("data-token")},getCorrelationId:function(){var a;if(!this.config.current.cookie)return this.util.uuid();try{a=this.document.cookie.replace(/(?:(?:^|.*;\s*)TrackJS\s*\=\s*([^;]*).*$)|^.*$/,"$1"),a||(a=this.util.uuid(),this.document.cookie="TrackJS="+a+"; expires=Fri, 31 Dec 9999 23:59:59 GMT; path=/")}catch(c){a=this.util.uuid()}return a},report:function(){return{application:this.config.current.application,correlationId:this.correlationId,
sessionId:this.config.current.sessionId,token:this.token,userId:this.config.current.userId,version:this.config.current.version}}};var w=function(a){this.loadedOn=(new Date).getTime();this.window=a};w.prototype={discoverDependencies:function(){var a,c={};this.window.jQuery&&this.window.jQuery.fn&&this.window.jQuery.fn.jquery&&(c.jQuery=this.window.jQuery.fn.jquery);this.window.jQuery&&this.window.jQuery.ui&&this.window.jQuery.ui.version&&(c.jQueryUI=this.window.jQuery.ui.version);this.window.angular&&
this.window.angular.version&&this.window.angular.version.full&&(c.angular=this.window.angular.version.full);for(a in this.window)if("_trackJs"!==a&&"_trackJS"!==a&&"_trackjs"!==a&&"webkitStorageInfo"!==a&&"webkitIndexedDB"!==a&&"top"!==a&&"parent"!==a&&"frameElement"!==a)try{if(this.window[a]){var b=this.window[a].version||this.window[a].Version||this.window[a].VERSION;"string"===typeof b&&(c[a]=b)}}catch(d){}return c},report:function(){return{age:(new Date).getTime()-this.loadedOn,dependencies:this.discoverDependencies(),
userAgent:this.window.navigator.userAgent,viewportHeight:this.window.document.documentElement.clientHeight,viewportWidth:this.window.document.documentElement.clientWidth}}};var y=function(a){this.util=a;this.appender=[];this.maxLength=30};y.prototype={all:function(a){var c=[],b,d;for(d=0;d<this.appender.length;d++)(b=this.appender[d])&&b.category===a&&c.push(b.value);return c},clear:function(){this.appender.length=0},truncate:function(){this.appender.length>this.maxLength&&(this.appender=this.appender.slice(Math.max(this.appender.length-
this.maxLength,0)))},add:function(a,c){var b=this.util.uuid();this.appender.push({key:b,category:a,value:c});this.truncate();return b},get:function(a,c){var b,d;for(d=0;d<this.appender.length;d++)if(b=this.appender[d],b.category===a&&b.key===c)return b.value;return!1}};var z=function(a,c){this.log=a;this.options=c;c.enabled&&this.watch()};z.prototype={isCompatible:function(a){a=a||h;return!f.has(a,"chrome.app.runtime")&&f.has(a,"addEventListener")&&f.has(a,"history.pushState")},record:function(a,
c,b){this.log.add("h",{type:a,from:f.truncate(c,250),to:f.truncate(b,250),on:f.isoNow()})},report:function(){return this.log.all("h")},watch:function(){if(this.isCompatible()){var a=this,c=f.getLocationURL().relative;h.addEventListener("popstate",function(){var b=f.getLocationURL().relative;a.record("popState",c,b);c=b},!0);f.forEach(["pushState","replaceState"],function(b){f.patch(history,b,function(d){return function(){c=f.getLocationURL().relative;var e=d.apply(this,arguments),g=f.getLocationURL().relative;
a.record(b,c,g);c=g;return e}})})}}};var A=function(a,c,b,d,e,g){this.util=a;this.log=c;this.onError=b;this.onFault=d;this.window=e;this.options=g;g.enabled&&this.initialize(e)};A.prototype={initialize:function(a){a.XMLHttpRequest&&this.util.hasFunction(a.XMLHttpRequest.prototype.open,"apply")&&this.watchNetworkObject(a.XMLHttpRequest);a.XDomainRequest&&this.util.hasFunction(a.XDomainRequest.prototype.open,"apply")&&this.watchNetworkObject(a.XDomainRequest)},watchNetworkObject:function(a){var c=this,
b=a.prototype.open,d=a.prototype.send;a.prototype.open=function(a,c){var d=(c||"").toString();0>d.indexOf("localhost:0")&&(this._trackJs={method:a,url:d});return b.apply(this,arguments)};a.prototype.send=function(){try{if(!this._trackJs)return d.apply(this,arguments);this._trackJs.logId=c.log.add("n",{startedOn:c.util.isoNow(),method:this._trackJs.method,url:this._trackJs.url});c.listenForNetworkComplete(this)}catch(a){c.onFault(a)}return d.apply(this,arguments)};return a},listenForNetworkComplete:function(a){var c=
this;c.window.ProgressEvent&&a.addEventListener&&a.addEventListener("readystatechange",function(){4===a.readyState&&c.finalizeNetworkEvent(a)},!0);a.addEventListener?a.addEventListener("load",function(){c.finalizeNetworkEvent(a);c.checkNetworkFault(a)},!0):setTimeout(function(){try{var b=a.onload;a.onload=function(){c.finalizeNetworkEvent(a);c.checkNetworkFault(a);"function"===typeof b&&c.util.hasFunction(b,"apply")&&b.apply(a,arguments)};var d=a.onerror;a.onerror=function(){c.finalizeNetworkEvent(a);
c.checkNetworkFault(a);"function"===typeof oldOnError&&d.apply(a,arguments)}}catch(e){c.onFault(e)}},0)},finalizeNetworkEvent:function(a){if(a._trackJs){var c=this.log.get("n",a._trackJs.logId);c&&(c.completedOn=this.util.isoNow(),c.statusCode=1223==a.status?204:a.status,c.statusText=1223==a.status?"No Content":a.statusText)}},checkNetworkFault:function(a){if(this.options.error&&400<=a.status&&1223!=a.status){var c=a._trackJs||{};this.onError("ajax",a.status+" "+a.statusText+": "+c.method+" "+c.url)}},
report:function(){return this.log.all("n")}};var q=function(a,c){this.util=a;this.config=c;this.disabled=!1;this.throttleStats={attemptCount:0,throttledCount:0,lastAttempt:(new Date).getTime()};h.JSON&&h.JSON.stringify||(this.disabled=!0)};q.prototype={errorEndpoint:function(a){var c=this.config.current.errorURL;this.util.testCrossdomainXhr()||-1!==h.location.protocol.indexOf("https")||(c=this.config.current.errorNoSSLURL);return c+"?token="+a},usageEndpoint:function(a){return this.appendObjectAsQuery(a,
this.config.current.usageURL)},trackerFaultEndpoint:function(a){return this.appendObjectAsQuery(a,this.config.current.faultURL)},appendObjectAsQuery:function(a,c){c+="?";for(var b in a)a.hasOwnProperty(b)&&(c+=encodeURIComponent(b)+"="+encodeURIComponent(a[b])+"&");return c},getCORSRequest:function(a,c){var b;this.util.testCrossdomainXhr()?(b=new h.XMLHttpRequest,b.open(a,c),b.setRequestHeader("Content-Type","text/plain")):"undefined"!==typeof h.XDomainRequest?(b=new h.XDomainRequest,b.open(a,c)):
b=null;return b},sendTrackerFault:function(a){this.throttle(a)||((new Image).src=this.trackerFaultEndpoint(a))},sendUsage:function(a){(new Image).src=this.usageEndpoint(a)},sendError:function(a,c){var b=this;if(!this.disabled&&!this.throttle(a))try{var d=this.getCORSRequest("POST",this.errorEndpoint(c));d.onreadystatechange=function(){4===d.readyState&&200!==d.status&&(b.disabled=!0)};d._trackJs=m;d.send(h.JSON.stringify(a))}catch(e){throw this.disabled=!0,e;}},throttle:function(a){var c=(new Date).getTime();
this.throttleStats.attemptCount++;if(this.throttleStats.lastAttempt+1E3>=c){if(this.throttleStats.lastAttempt=c,10<this.throttleStats.attemptCount)return this.throttleStats.throttledCount++,!0}else a.throttled=this.throttleStats.throttledCount,this.throttleStats.attemptCount=0,this.throttleStats.lastAttempt=c,this.throttleStats.throttledCount=0;return!1}};var f=function(){function a(a){return Object.prototype.toString.call(a)}return{bind:function(a,b){return function(){return a.apply(b,Array.prototype.slice.call(arguments))}},
contains:function(a,b){var d;for(d=0;d<a.length;d++)if(a[d]===b)return!0;return!1},defer:function(a,b){setTimeout(function(){a.apply(b)})},extend:function(a){for(var b,d=Array.prototype.slice.call(arguments,1),e=0;e<d.length;e++)for(b in d[e])null===d[e][b]||d[e][b]===m?a[b]=d[e][b]:"[object Object]"===Object.prototype.toString.call(d[e][b])?(a[b]=a[b]||{},this.extend(a[b],d[e][b])):a[b]=d[e][b];return a},forEach:function(a,b,d){if(a.forEach)return a.forEach(b,d);for(var e=0;e<a.length;)b.call(d,
a[e],e,a),e++},getLocation:function(){return h.location.toString().replace(/ /g,"%20")},getLocationURL:function(){return f.parseURL(f.getLocation())},has:function(a,b){for(var d=b.split("."),e=a,g=0;g<d.length;g++)if(e[d[g]])e=e[d[g]];else return!1;return!0},hasFunction:function(a,b){try{return!!a[b]}catch(d){return!1}},isArray:function(c){return"[object Array]"===a(c)},isBoolean:function(c){return"boolean"===typeof c||f.isObject(c)&&"[object Boolean]"===a(c)},isBrowserIE:function(a){a=a||h.navigator.userAgent;
var b=a.match(/Trident\/([\d.]+)/);return b&&"7.0"===b[1]?11:(a=a.match(/MSIE ([\d.]+)/))?parseInt(a[1],10):!1},isBrowserSupported:function(){var a=this.isBrowserIE();return!a||8<=a},isError:function(c){if(!f.isObject(c))return!1;var b=a(c);return"[object Error]"===b||"[object DOMException]"===b||f.isString(c.name)&&f.isString(c.message)},isFunction:function(a){return!(!a||"function"!==typeof a)},isNumber:function(c){return"number"===typeof c||f.isObject(c)&&"[object Number]"===a(c)},isObject:function(a){return!(!a||
"object"!==typeof a)},isString:function(c){return"string"===typeof c||!f.isArray(c)&&f.isObject(c)&&"[object String]"===a(c)},isWrappableFunction:function(a){return this.isFunction(a)&&this.hasFunction(a,"apply")},isoNow:function(){var a=new Date;return a.toISOString?a.toISOString():a.getUTCFullYear()+"-"+this.pad(a.getUTCMonth()+1)+"-"+this.pad(a.getUTCDate())+"T"+this.pad(a.getUTCHours())+":"+this.pad(a.getUTCMinutes())+":"+this.pad(a.getUTCSeconds())+"."+String((a.getUTCMilliseconds()/1E3).toFixed(3)).slice(2,
5)+"Z"},noop:function(){},pad:function(a){a=String(a);1===a.length&&(a="0"+a);return a},parseURL:function(a){var b=a.match(/^(([^:\/?#]+):)?(\/\/([^\/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?$/);if(!b)return{};b={protocol:b[2],host:b[4],path:b[5],query:b[6],hash:b[8]};b.origin=(b.protocol||"")+"://"+(b.host||"");b.relative=(b.path||"")+(b.query||"")+(b.hash||"");b.href=a;return b},patch:function(a,b,d){a[b]=d(a[b]||f.noop)},testCrossdomainXhr:function(){return"withCredentials"in new XMLHttpRequest},truncate:function(a,
b){if(a.length<=b)return a;var d=a.length-b;return a.substr(0,b)+"...{"+d+"}"},uuid:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(a){var b=16*Math.random()|0;return("x"==a?b:b&3|8).toString(16)})},wrapError:function(a){if(a.innerError)return a;var b=Error("TrackJS Caught: "+(a.message||a));b.description="TrackJS Caught: "+a.description;b.file=a.file;b.line=a.line||a.lineNumber;b.column=a.column||a.columnNumber;b.stack=a.stack;b.innerError=a;return b}}}(),B=function(a,
c,b,d,e,g){this.util=a;this.log=c;this.onError=b;this.onFault=d;this.options=g;this.document=e;g.enabled&&this.initialize(e)};B.prototype={initialize:function(a){var c=this.util.bind(this.onDocumentClicked,this),b=this.util.bind(this.onInputChanged,this);a.addEventListener?(a.addEventListener("click",c,!0),a.addEventListener("blur",b,!0)):a.attachEvent&&(a.attachEvent("onclick",c),a.attachEvent("onfocusout",b))},onDocumentClicked:function(a){try{var c=this.getElementFromEvent(a);c&&c.tagName&&(this.isDescribedElement(c,
"a")||this.isDescribedElement(c,"button")||this.isDescribedElement(c,"input",["button","submit"])?this.writeVisitorEvent(c,"click"):this.isDescribedElement(c,"input",["checkbox","radio"])&&this.writeVisitorEvent(c,"input",c.value,c.checked))}catch(b){this.onFault(b)}},onInputChanged:function(a){try{var c=this.getElementFromEvent(a);if(c&&c.tagName)if(this.isDescribedElement(c,"textarea"))this.writeVisitorEvent(c,"input",c.value);else if(this.isDescribedElement(c,"select")&&c.options&&c.options.length)this.onSelectInputChanged(c);
else this.isDescribedElement(c,"input")&&!this.isDescribedElement(c,"input",["button","submit","hidden","checkbox","radio"])&&this.writeVisitorEvent(c,"input",c.value)}catch(b){this.onFault(b)}},onSelectInputChanged:function(a){if(a.multiple)for(var c=0;c<a.options.length;c++)a.options[c].selected&&this.writeVisitorEvent(a,"input",a.options[c].value);else 0<=a.selectedIndex&&a.options[a.selectedIndex]&&this.writeVisitorEvent(a,"input",a.options[a.selectedIndex].value)},writeVisitorEvent:function(a,
c,b,d){"password"===this.getElementType(a)&&(b=m);this.log.add("v",{timestamp:this.util.isoNow(),action:c,element:{tag:a.tagName.toLowerCase(),attributes:this.getElementAttributes(a),value:this.getMetaValue(b,d)}})},getElementFromEvent:function(a){return a.target||x.elementFromPoint(a.clientX,a.clientY)},isDescribedElement:function(a,c,b){if(a.tagName.toLowerCase()!==c.toLowerCase())return!1;if(!b)return!0;a=this.getElementType(a);for(c=0;c<b.length;c++)if(b[c]===a)return!0;return!1},getElementType:function(a){return(a.getAttribute("type")||
"").toLowerCase()},getElementAttributes:function(a){for(var c={},b=0;b<a.attributes.length;b++)"value"!==a.attributes[b].name.toLowerCase()&&(c[a.attributes[b].name]=a.attributes[b].value);return c},getMetaValue:function(a,c){return a===m?m:{length:a.length,pattern:this.matchInputPattern(a),checked:c}},matchInputPattern:function(a){return""===a?"empty":/^[a-z0-9!#$%&'*+=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/.test(a)?"email":
/^(0?[1-9]|[12][0-9]|3[01])[\/\-](0?[1-9]|1[012])[\/\-]\d{4}$/.test(a)||/^(\d{4}[\/\-](0?[1-9]|1[012])[\/\-]0?[1-9]|[12][0-9]|3[01])$/.test(a)?"date":/^(?:(?:\+?1\s*(?:[.-]\s*)?)?(?:\(\s*([2-9]1[02-9]|[2-9][02-8]1|[2-9][02-8][02-9])\s*\)|([2-9]1[02-9]|[2-9][02-8]1|[2-9][02-8][02-9]))\s*(?:[.-]\s*)?)?([2-9]1[02-9]|[2-9][02-9]1|[2-9][02-9]{2})\s*(?:[.-]\s*)?([0-9]{4})(?:\s*(?:#|x\.?|ext\.?|extension)\s*(\d+))?$/.test(a)?"usphone":/^\s*$/.test(a)?"whitespace":/^\d*$/.test(a)?"numeric":/^[a-zA-Z]*$/.test(a)?
"alpha":/^[a-zA-Z0-9]*$/.test(a)?"alphanumeric":"characters"},report:function(){return this.log.all("v")}};var C=function(a,c,b,d,e){this.onError=a;this.onFault=c;this.serialize=b;e.enabled&&this.watchWindowErrors(d);e.promise&&this.watchPromiseErrors(d)};C.prototype={watchPromiseErrors:function(a){if(a.addEventListener){var c=this;a.addEventListener("unhandledrejection",function(a){c.onError("window",(a||{}).reason)})}},watchWindowErrors:function(a){var c=this,b=a.onerror||function(){};a.onerror=
function(d,e,g,f,l){try{l=l||{},l.message=l.message||c.serialize(d),l.line=l.line||parseInt(g,10)||null,l.column=l.column||parseInt(f,10)||null,"[object Event]"!==Object.prototype.toString.call(d)||e?l.file=l.file||c.serialize(e):l.file=(d.target||{}).src,c.onError("window",l)}catch(h){c.onFault(h)}b.call(a,d,e,g,f,l)}}};var D=function(a,c,b,d,e,g,k,l,h,m,n,p,q,x,t,u,v){try{if(this.window=t,this.document=u,this.util=f,this.onError=this.util.bind(this.onError,this),this.onFault=this.util.bind(this.onFault,
this),this.serialize=this.util.bind(this.serialize,this),this.config=new d(this.util,a),this.transmitter=new n(this.util,this.config),this.log=new l(this.util),this.api=new c(this.config,this.util,this.onError,this.serialize),this.metadata=new h(this.serialize),this.environment=new k(this.window),this.customer=new g(this.config,this.util,this.log,this.window,this.document),this.customer.token&&(this.apiConsoleWatcher=new e(this.util,this.log,this.onError,this.onFault,this.serialize,this.api,this.config.defaults.console),
this.config.current.enabled&&(this.windowConsoleWatcher=new e(this.util,this.log,this.onError,this.onFault,this.serialize,this.window,this.config.current.console),this.util.isBrowserSupported()))){this.callbackWatcher=new b(this.util,this.onError,this.onFault,this.window,this.config.current.callback);this.visitorWatcher=new p(this.util,this.log,this.onError,this.onFault,this.document,this.config.current.visitor);this.navigationWatcher=new v(this.log,this.config.current.navigation);this.networkWatcher=
new m(this.util,this.log,this.onError,this.onFault,this.window,this.config.current.network);this.windowWatcher=new q(this.onError,this.onFault,this.serialize,this.window,this.config.current.window);var r=this;setTimeout(function(){r.transmitter.sendUsage({token:r.customer.token,correlationId:r.customer.correlationId,application:r.config.current.application,x:r.util.uuid()})},1E3)}}catch(w){this.onFault(w)}};D.prototype={reveal:function(){if(this.customer.token)return this.api.addMetadata=this.metadata.addMetadata,
this.api.removeMetadata=this.metadata.removeMetadata,this.api;this.window.console&&this.window.console.warn&&this.window.console.warn("TrackJS could not find a token");return m},onError:function(){var a=!1;return function(c,b,d){if(this.util.isBrowserSupported()&&this.config.current.enabled)try{b=b||{};d=d||{bindStack:null,bindTime:null,force:!1};var e=b.message||this.serialize(b,d.force);if(e&&e.indexOf){if(-1!==e.indexOf("TrackJS Caught"))return;if(a&&-1!==e.indexOf("Script error")){a=!1;return}}var g=
this.util.extend({},{bindStack:d.bindStack,bindTime:d.bindTime,column:b.column||b.columnNumber,console:this.windowConsoleWatcher.report(),customer:this.customer.report(),entry:c,environment:this.environment.report(),file:b.file||b.fileName,line:b.line||b.lineNumber,message:e,metadata:this.metadata.report(),nav:this.navigationWatcher.report(),network:this.networkWatcher.report(),url:(h.location||"").toString(),stack:b.stack,timestamp:this.util.isoNow(),visitor:this.visitorWatcher.report(),version:"2.6.3"});
if(!d.force)try{if(!this.config.current.onError(g,b))return}catch(f){g.console.push({timestamp:this.util.isoNow(),severity:"error",message:f.message});var k=this;setTimeout(function(){k.onError("catch",f,{force:!0})},0)}this.log.clear();setTimeout(function(){a=!1});a=!0;this.transmitter.sendError(g,this.customer.token)}catch(f){this.onFault(f)}}}(),onFault:function(a){var c=this.transmitter||new q;a=a||{};a={token:this.customer.token,file:a.file||a.fileName,msg:a.message||"unknown",stack:(a.stack||
"unknown").substr(0,500),url:this.window.location,v:"2.6.3",h:"eadad7eadf8ed528c897735bdf13274d74711896",x:this.util.uuid()};c.sendTrackerFault(a)},serialize:function(a,c){if(this.config.current.serialize&&!c)try{return this.config.current.serialize(a)}catch(b){this.onError("catch",b,{force:!0})}return this.config.defaults.serialize(a)}};n=new D(h._trackJs||h._trackJS||h._trackjs||{},function(a,c,b,d){return{attempt:function(a,d){try{var f=Array.prototype.slice.call(arguments,2);return a.apply(d||
this,f)}catch(h){throw b("catch",h),c.wrapError(h);}},configure:function(b){return a.setCurrent(b)},track:function(a){var c=d(a);a=a||{};if(!a.stack)try{throw Error(c);}catch(f){a=f}b("direct",a)},watch:function(a,d){return function(){try{var f=Array.prototype.slice.call(arguments,0);return a.apply(d||this,f)}catch(h){throw b("catch",h),c.wrapError(h);}}},watchAll:function(a){var d=Array.prototype.slice.call(arguments,1),f;for(f in a)"function"===typeof a[f]&&(c.contains(d,f)||function(){var d=a[f];
a[f]=function(){try{var a=Array.prototype.slice.call(arguments,0);return d.apply(this,a)}catch(e){throw b("catch",e),c.wrapError(e);}}}());return a},hash:"eadad7eadf8ed528c897735bdf13274d74711896",version:"2.6.3"}},n,t,u,v,w,y,function(a){var c={};return{addMetadata:function(a,d){c[a]=d},removeMetadata:function(a){delete c[a]},report:function(){var b=[],d;for(d in c)c.hasOwnProperty(d)&&b.push({key:d,value:a(c[d])});return b},store:c}},A,q,B,C,p,h,x,z);h.trackJs=n.reveal()}})(window,document);
